<?php
$params = array_merge(
    require(__DIR__ . '/../../common/config/params.php'),
    require(__DIR__ . '/../../common/config/params-local.php'),
    require(__DIR__ . '/params.php'),
    require(__DIR__ . '/params-local.php')
);

return [
    'id' => 'app-backdoor',
    'basePath' => dirname(__DIR__),
    'controllerNamespace' => 'backdoor\controllers',
    'bootstrap' => ['log'],
    'modules' => [],
    'components' => [
        'request' => [
            'parsers' => [
                'application/json' => 'yii\web\JsonParser',
                'application/xml' => 'yii\web\XmlParser',
                'multipart/form-data' => 'yii\web\MultipartFormDataParser', // !!!!!!!
            ],
        ],
        'response' => [
            'formatters' => [
                'json' => [
                    'class' => 'yii\web\JsonResponseFormatter',
                    'prettyPrint' => YII_DEBUG,
                    'encodeOptions' => JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE,
                ],
            ],
        ],
        'user' => [
            'identityClass' => 'common\models\User',
            'enableAutoLogin' => false,
            'enableSession' => false,
        ],
        'log' => [
            'traceLevel' => 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'categories' => ['botinfo'],
                    'levels' => ['info'],
                    'exportInterval' => 1,
                    'logVars' => [],
                    'logFile' => '@app/runtime/logs/botinfo.log',
                ],
                
                
            ],
        ],
        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'rules' => [
                '/<prefix:[A-Za-z0-9]+>/<bot:[A-Za-z0-9]+>/<options:[A-Za-z0-9]+>' => 'site/index',
            ],
        ],
    ],
    'params' => $params,
];
